#!/usr/bin/perl
use strict;
use warnings;
use File::Find;

my $KEEP_THIS_MANY=50;
my $PICEXT='png';

sub found {
	if ( -f $_ && m/(.+?)(\d+)\.\Q$PICEXT\E$/ ) {
		print "$_ $1 $2\n";	
		if ($2 > $KEEP_THIS_MANY) {
			print "unlink $_\n";
			unlink($_) or die "unlink: $!";
		}
	}
	if ( -f $_ && m/^\d{8}.\Qpng\E$/ ) {
		print "unlink $_\n";
		unlink($_) or die "unlink: $!";
	}
}
foreach my $arg (@ARGV) {
	if ( ! -d $arg ) {
		die "$arg: not a directory, see usage";
	}
}
find(\&found,@ARGV);


